
type Topics = {
  "event.post": EventPost1Data;

};

type Callbacks<T extends keyof Topics> = (data: Topics[T]) => void;

class EventBus<T extends keyof Topics> {
  private subscribers: { [K in T]?: Callbacks<K>[] } = {};

  subscribe<K extends T>(topic: K, callback: Callbacks<K>): void {
    if (!this.subscribers[topic]) {
      this.subscribers[topic] = [];
    }
    this.subscribers[topic]?.push(callback);
  }

  unsubscribe<K extends T>(topic: K, callback: Callbacks<K>): void {
    const callbacks = this.subscribers[topic];
    if (callbacks) {
      this.subscribers[topic] = callbacks.filter(cb => cb !== callback);
    }
  }

  publish<K extends T>(topic: K, payload: Topics[K]): void {
    const callbacks = this.subscribers[topic];
    if (callbacks) {
      for (const callback of callbacks) {
        callback(payload);
      }
    }
  }
}

// Define topics and their corresponding payload types
export const msgbus = new EventBus();